#pragma once

#include "Areas.h"
#include "libIncludes\MiniSAX.h"

/*******************************************
  Classes to parse areas configuration data
 *******************************************/


using	miniSAX::CMiniSAXException;
using	miniSAX::CContentHandler;
using	miniSAX::CAttribute;
using	miniSAX::CAttributeList;
using	miniSAX::CMiniSAXParser;


class CSubContentHandler : public CContentHandler {
public:
	CSubContentHandler(CMiniSAXParser* aParser) { parser = aParser; endOfElement = false; subHandler = NULL; }
	virtual ~CSubContentHandler() {}

	virtual bool elementEnded() const { return endOfElement; }
protected:
	CMiniSAXParser*		parser;
	bool				endOfElement;
	CSubContentHandler*	subHandler;
};


class CGroupContentHandler : public CSubContentHandler {
public:
	CGroupContentHandler(CMiniSAXParser* aParser);
	virtual ~CGroupContentHandler();

    virtual void startElement(const char* name, const CAttributeList& attributes)
        throw (CMiniSAXException);
    virtual void endElement(const char* name)
        throw (CMiniSAXException);

    virtual void handleCharacters(const char* buffer, size_t len)
        throw (CMiniSAXException);
protected:
	enum states {
		ROOT_STATE,
		GROUP_STATE
	};
	int			state;
	PAreaGroup	group;
};


class CAreaContentHandler : public CSubContentHandler {
public:
	CAreaContentHandler(CMiniSAXParser* aParser);
	virtual ~CAreaContentHandler();

    virtual void startElement(const char* name, const CAttributeList& attributes)
        throw (CMiniSAXException);
    virtual void endElement(const char* name)
        throw (CMiniSAXException);

    virtual void handleCharacters(const char* buffer, size_t len)
        throw (CMiniSAXException);

	virtual PArea detachArea();
protected:
	enum states {
		ROOT_STATE,
		AREA_STATE,
		PASSTHROUGH_STATE,
		VETO_MANUAL_PURGE_STATE,
		OPEN_FOR_RESEND_STATE,
		OUTBOUND_STATE,
		LINKED_STATE
	};
	int		state;
	PArea	area;
	int		linkRouting;
};


class CAreasContentHandler : public CContentHandler {
public:
    CAreasContentHandler(CMiniSAXParser* aParser);
    virtual ~CAreasContentHandler();

    virtual void startElement(const char* name, const CAttributeList& attributes)
        throw (CMiniSAXException);
    virtual void endElement(const char* name)
        throw (CMiniSAXException);

    virtual void handleCharacters(const char* buffer, size_t len)
        throw (CMiniSAXException);

protected:
	int				state;
	enum states {
		ROOT_STATE,
		AREAS_STATE
	};

	CMiniSAXParser*		parser;
	CSubContentHandler*	subHandler;
};
